<?php
include_once 'inc/navigation.php';
?>

   <main>

      <!-- breadcrumb-area-start -->
      <div class="it-breadcrumb-area it-breadcrumb-bg" data-background="images/students_in_class_joy_studio_academy.webp">
         <div class="container">
            <div class="row ">
               <div class="col-md-12">
                  <div class="it-breadcrumb-content z-index-3 text-center">
                     <div class="it-breadcrumb-title-box">
                        <h3 class="it-breadcrumb-title">about us</h3>
                     </div>
                     <div class="it-breadcrumb-list-wrap">
                        <div class="it-breadcrumb-list">
                           <span><a href="/">home</a></span> 
                           <span class="dvdr">//</span>
                           <span>about us</span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- breadcrumb-area-end -->

      <!-- about-area-start -->
      <div class="it-about-4-area  inner-about-style pt-120 pb-120">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-6 col-lg-6">
                  <div class="it-about-4-thumb-wrap d-flex align-items-center justify-content-center justify-content-lg-end">
                     <div class="it-about-4-thumb-double d-flex flex-column">
                        <img class="mb-20" src="images/teacher_gentleman.webp" alt="<?= $site_name ?>" loading="lazy">
                        <img src="images/student_in_lab.webp" alt="<?= $site_name ?>" loading="lazy">
                     </div>
                     <div class="it-about-4-thumb-single">
                        <img src="images/student_about.webp" alt="<?= $site_name ?>" loading="lazy">
                     </div>
                  </div>
               </div>
               <div class="col-xl-6 col-lg-6">
                    <div class="it-about-3-title-box">
                        <span class="it-section-subtitle">
                            <img src="assets/img/category/inner.svg" alt="<?= $site_name ?>" loading="lazy">
                            About Joy Sounds Academy
                        </span>
                        <h2 class="it-section-title-3 pb-30">
                            A Thoughtful Approach to <span>Learning & Growth</span>
                        </h2>
                        <p>
                            Joy Sounds Academy & Junior School is built on the belief that every child learns best
                            when they feel safe, supported, and understood. We create an environment where learners
                            are encouraged to ask questions, express themselves, and grow with confidence—both in
                            and beyond the classroom.
                        </p>
                    </div>

                    <div class="it-about-3-mv-box">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="it-about-4-list-wrap d-flex align-items-start">
                                    <div class="it-about-4-list-icon">
                                        <span><i class="flaticon-video-1"></i></span>
                                    </div>
                                    <div class="it-about-3-mv-item">
                                        <span class="it-about-3-mv-title">Engaged & Guided Learning</span>
                                        <p>
                                            Our teachers take time to understand each learner, guiding them with
                                            patience and clarity while encouraging curiosity, participation, and
                                            independent thinking.
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="it-about-4-list-wrap d-flex align-items-start">
                                    <div class="it-about-4-list-icon">
                                        <span><i class="flaticon-puzzle"></i></span>
                                    </div>
                                    <div class="it-about-3-mv-item">
                                        <span class="it-about-3-mv-title">Balanced Development</span>
                                        <p>
                                            We focus on academic progress alongside social, emotional, physical,
                                            and spiritual development—helping learners build strong foundations
                                            for life, not just exams.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="it-about-3-btn-box p-relative">
                        <a class="it-btn" href="documents/JoySoundAcademy_Fee&Admission_Letter.pdf" target="_blank">
                            <span>
                                Begin the Admission Process
                                <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                        stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                        stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </span>
                        </a>
                        <div class="it-about-3-left-shape-3 d-none d-xl-block">
                            <img src="assets/img/about/about-3-shap-3.png" alt="" loading="lazy">
                        </div>
                    </div>
                </div>

            </div>
         </div>
      </div>
      <!-- about-area-end -->

      <!-- funfact-area-start -->
      <div class="it-funfact-area z-index-5">
         <div class="container">
            <div class="it-funfact-bg-wrap theme-bg" data-background="assets/img/funfact/funfact-bg.png">
               <div class="row gx-0">
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="it-funfact-item d-flex align-items-center">
                            <div class="it-funfact-icon">
                                <span><i class="flaticon-teacher"></i></span>
                            </div>
                            <div class="it-funfact-content text-white">
                                <h6><i class="purecounter" data-purecounter-duration="1" data-purecounter-end="25">0</i>+</h6>
                                <span>Qualified Teachers</span>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="it-funfact-item d-flex align-items-center">
                            <div class="it-funfact-icon">
                                <span><i class="flaticon-completed-task"></i></span>
                            </div>
                            <div class="it-funfact-content">
                                <h6><i class="purecounter" data-purecounter-duration="1" data-purecounter-end="50">0</i>+</h6>
                                <span>Courses Delivered</span>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="it-funfact-item d-flex align-items-center">
                            <div class="it-funfact-icon">
                                <span><i class="flaticon-customer-review"></i></span>
                            </div>
                            <div class="it-funfact-content">
                                <h6><i class="purecounter" data-purecounter-duration="1" data-purecounter-end="98">0</i>%</h6>
                                <span>Parent Satisfaction Rate</span>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="it-funfact-item d-flex align-items-center">
                            <div class="it-funfact-icon">
                                <span><i class="flaticon-class"></i></span>
                            </div>
                            <div class="it-funfact-content">
                                <h6><i class="purecounter" data-purecounter-duration="1" data-purecounter-end="500">0</i>+</h6>
                                <span>Active Students</span>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
         </div>
      </div>
      <!-- funfact-area-end -->

      <!-- testimonial-area-start -->
      <div class="it-testimonial-area it-testimonial-ptb it-sub-bg-none it-testimonial-bg fix p-relative" data-background="assets/img/testimonial/testimonial-bg.jpg">
        
         <div class="container">
            <div class="it-testimonial-title-wrap mb-60">
               <div class="row align-items-end">
                  <div class="col-xl-6 col-lg-8 col-md-9 col-sm-8">
                     <div class="it-testimonial-title-box">
                        <span class="it-section-subtitle">
                           <img src="assets/img/category/inner.svg" alt="">
                           testimonial
                        </span>
                        <h4 class="it-section-title">Creating A Community Of Life Long                                                  
                           <span class="p-relative z-index">Learners.
                              <svg class="title-shape-3" width="169" height="65" viewBox="0 0 169 65" fill="none" xmlns="http://www.w3.org/2000/svg">
                                 <path d="M73.9865 8.52241C79.0935 6.03398 83.1809 4.26476 89.5018 3.31494C94.8148 2.51659 100.239 2.08052 105.59 1.95274C121.035 1.5839 135.743 4.94481 147.12 9.7789C159.246 14.931 167.348 22.7171 166.701 31.8511C165.923 42.8363 151.983 52.0035 134.146 57.1364C110.893 63.8284 82.3457 64.1305 59.197 61.1289C38.1374 58.3982 12.2599 51.9446 4.20444 40.1836C-2.8133 29.9382 12.6851 18.2085 28.1538 11.6691C40.9733 6.24978 56.315 2.97602 71.4123 4.09034C82.5481 4.91227 93.8269 6.91079 103.074 10.0494C113.489 13.5844 120.759 18.7016 128.482 23.7722" stroke="#0AB99D" stroke-width="3" stroke-linecap="round"/>
                                 </svg>
                           </span>
                        </h4>
                     </div>
                  </div>
                  <div class="col-xl-6 col-lg-4 col-md-3 col-sm-4">
                     <div class="it-testimonial-arrow text-end"></div>
                  </div>
               </div>
            </div>
            <div class="row">
              <div class="col-xl-12">
                  <div class="it-testimonial-slide-wrap p-relative">
                     <div class="it-testimonial-slide-quote d-none d-xl-block">
                        <i class="fa-sharp fa-solid fa-quote-right"></i>
                     </div>
                     <div class="row align-items-center">
                        <div class="col-xl-9 col-lg-9 col-md-9">
                            <div class="it-testimonial-slide-active">
                                <div class="it-testimonial-slide-item">
                                    <div class="it-testimonial-slide-info">
                                        <h4 class="it-testimonial-user-name">Grace Mwikali</h4>
                                        <span>Parent</span>
                                        <p>“Joy Sounds Academy has been amazing for my daughter. The teachers are patient and nurturing, and I’ve seen her confidence and curiosity grow tremendously since joining. The environment feels safe, welcoming, and inspiring.”</p>
                                    </div>
                                </div>
                                
                                <div class="it-testimonial-slide-item">
                                    <div class="it-testimonial-slide-info">
                                        <h4 class="it-testimonial-user-name">David Mutua</h4>
                                        <span>Parent</span>
                                        <p>“From the very first day, the school impressed us with its dedication to holistic learning. My son is thriving academically and socially, and he loves being at school every day. The staff truly care about each child’s growth.”</p>
                                    </div>
                                </div>
                                
                                <div class="it-testimonial-slide-item">
                                    <div class="it-testimonial-slide-info">
                                        <h4 class="it-testimonial-user-name">Aisha Njeri</h4>
                                        <span>Student</span>
                                        <p>“I really enjoy coming to school here! The lessons are fun and interesting, and the teachers make sure everyone understands. I feel encouraged to ask questions and explore new ideas every day.”</p>
                                    </div>
                                </div>
                                
                                <div class="it-testimonial-slide-item">
                                    <div class="it-testimonial-slide-info">
                                        <h4 class="it-testimonial-user-name">Samuel Karanja</h4>
                                        <span>Parent</span>
                                        <p>“The school strikes the perfect balance between academics and personal development. My child is not only learning well but also building strong values, teamwork, and confidence. I couldn’t ask for a better environment for him.”</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                     </div>
                  </div>
              </div> 
            </div>
         </div>
      </div>
      <!-- testimonial-area-end -->
<?php
include_once 'inc/footer.php';
?>