<?php
include_once 'inc/dbconn.php';
?>

<!doctype html>
<html class="no-js" lang="zxx">


<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title>Joy Sounds Academy & Junior School | Quality Education in Makueni</title>
   
   <meta name="description" content="Joy Sounds Academy & Junior School in Makueni provides quality education for a quality life. We nurture super brains through academic, spiritual, and social excellence.">
   <meta name="keywords" content="Joy Sounds Academy, Junior School Makueni, Primary School Makueni, Best schools in Makueni, Quality Education Kenya">
   <meta name="author" content="Joy Sounds Academy">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="robots" content="index, follow">

   <meta property="og:type" content="website">
   <meta property="og:url" content="https://www.joysoundsacademy.co.ke/">
   <meta property="og:title" content="Joy Sounds Academy | Quality Education For Quality Life">
   <meta property="og:description" content="A child-friendly school in Makueni dedicated to producing super brains through holistic growth.">
   <meta property="og:image" content="images/joysoundsacademy_logo.webp">

   <meta property="twitter:card" content="summary_large_image">
   <meta property="twitter:title" content="Joy Sounds Academy & Junior School">
   <meta property="twitter:description" content="Providing quality education that meets academic, spiritual, physical and social needs in Makueni.">

   <link rel="shortcut icon" type="image/x-icon" href="images/joysoundsacademy_logo.webp">

   <link rel="stylesheet" href="assets/css/bootstrap.min.css">
   <link rel="stylesheet" href="assets/css/animate.css">
   <link rel="stylesheet" href="assets/css/custom-animation.css">
   <link rel="stylesheet" href="assets/css/slick.css">
   <link rel="stylesheet" href="assets/css/nice-select.css">
   <link rel="stylesheet" href="assets/css/flaticon_xoft.css">
   <link rel="stylesheet" href="assets/css/swiper-bundle.css">
   <link rel="stylesheet" href="assets/css/meanmenu.css">
   <link rel="stylesheet" href="assets/css/font-awesome-pro.css">
   <link rel="stylesheet" href="assets/css/magnific-popup.css">
   <link rel="stylesheet" href="assets/css/spacing.css">
   <link rel="stylesheet" href="assets/css/main.css">

   <script type="application/ld+json">
   {
     "@context": "https://schema.org",
     "@type": "School",
     "name": "Joy Sounds Academy and Junior School",
     "description": "To be a best child friendly school where super brains are produced.",
     "motto": "Quality Education For Quality Life",
     "address": {
       "@type": "PostalAddress",
       "addressLocality": "Makueni",
       "addressCountry": "KE"
     },
     "url": "https://www.joysoundsacademy.co.ke"
   }
   </script>
</head>

<body>

   <!-- preloader 
   <div id="preloader">
      <div class="preloader">
         <span></span>
         <span></span>
      </div>
   </div>-->
   <!-- preloader end  -->

   <!-- back-to-top-start  -->
   <button class="scroll-top scroll-to-target" data-target="html">
      <i class="far fa-angle-double-up"></i>
   </button>
   <!-- back-to-top-end  -->

   <!-- it-offcanvus-area-start -->
   <div class="it-offcanvas-area">
      <div class="itoffcanvas">
         <div class="it-offcanva-bottom-shape d-none d-xxl-block">
         </div>
         <div class="itoffcanvas__close-btn">
            <button class="close-btn"><i class="fal fa-times"></i></button>
         </div>
         <div class="itoffcanvas__logo">
            <a href="index.php">
               <img src="images/joysoundsacademy_logo.webp" alt="<?= $site_name ?>" loading="lazy">
            </a>
         </div>
         <div class="itoffcanvas__text">
            <p><strong>Motto:</strong> Quality Education For Quality Life.</p>
         </div>
         <div class="it-menu-mobile"></div>
         <div class="itoffcanvas__info">
            <h3 class="offcanva-title">Get In Touch</h3>
            <div class="it-info-wrapper mb-20 d-flex align-items-center">
               <div class="itoffcanvas__info-icon">
                  <a href="#" class="text-white">
                     <i class="fal fa-envelope"></i>
                  </a>
               </div>
               <div class="itoffcanvas__info-address">
                  <span>Email</span>
                  <a href="maito:<?= $site_email ?>"><?= $site_email ?></a>
               </div>
            </div>
            <div class="it-info-wrapper mb-20 d-flex align-items-center">
               <div class="itoffcanvas__info-icon">
                  <a href="#" >
                     <i class="fal fa-phone-alt" style="color: #fff;"></i>
                  </a>
               </div>
               <div class="itoffcanvas__info-address">
                  <span>Phone</span>
                  <a href="tel:<?= $site_hotline ?>"><?= $site_hotline ?></a>
               </div>
            </div>
            <div class="it-info-wrapper mb-20 d-flex align-items-center">
               <div class="itoffcanvas__info-icon">
                  <a href="#" style="color:white;">
                     <i class="fas fa-map-marker-alt"></i>
                  </a>
               </div>
                <div class="itoffcanvas__info-address">
                    <span>Location</span>
                    <a href="htits://www.google.com/maps/@37.4801311,22.8928877,3z" target="_blank">
                        <?= $site_address ?> 
                    </a>
                </div>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- it-offcanvus-area-end -->

   <header class="it-header-height">

      <!-- header-top-area-start -->
      <div class="it-header-2-top-area it-header-2-top-style black-bg">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-8 col-lg-6 col-md-5 col-sm-7">
                  <div class="it-header-2-top-left">
                     <ul class="text-center text-sm-start">
                        <li class="d-none d-xl-inline-block">
                           <a href="tel:<?= $site_hotline ?>">
                              <span>
                                 <i class="fa-light fa-phone-volume text-white"></i>
                              </span>
                              <?= $site_hotline ?>
                           </a>
                        </li>
                        <li class="d-none d-xl-inline-block">
                           <a href="mailto:<?= $site_email ?>">
                              <span>
                                 <i class="fa-light fa-envelope-open-text text-white"></i>
                              </span><?= $site_email ?>
                           </a>
                        </li>
                        <li>
                           <a href="#">
                              <span>
                                 <i class="fal fa-map-marker-alt text-white"></i>
                              </span>
                              <?= $site_address ?>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- header-top-area-end -->

      <!-- header-area-start -->
      <div id="header-sticky" class="it-header-5-area it-header-1-style it-header-2-style">
         <div class="container">
            <div class="it-header-wrap p-relative">
               <div class="row align-items-center">
                  <div class="col-xl-2 col-6">
                     <div class="it-header-5-logo">
                        <a href="index.php">
                            <img src="images/joysoundsacademy_logo.webp" alt="<?= $site_name ?>" loading="lazy" style="height: 100px;">
                        </a>
                     </div>
                  </div>
                  <div class="col-xl-7 d-none d-xl-block">
                     <div class="it-header-2-main-menu">
                        <nav class="it-menu-content">
                           <ul>
                                <li>
                                    <a href="index.php">home</a>
                                </li>
                                <li>
                                    <a href="about.php">about us</a>
                                </li>
                                <li>
                                    <a href="documents/JoySoundAcademy_Fee&Admission_Letter.pdf" target="_blank">Fee Structure</a>
                                </li>
                                <li>
                                    <a href="blog.php">blog</a>
                                </li>
                                <li>
                                    <a href="contact.php">contact</a>
                                </li>
                           </ul>
                        </nav>
                     </div>
                  </div>
                  <div class="col-xl-3 col-6">
                     <div class="it-header-2-right d-flex align-items-center justify-content-end">
                        <div class="it-header-2-button d-none d-lg-block">
                           <a class="it-btn-white sky-bg" href="contact.php">
                              <span>
                                 Contact Us
                                 <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                       stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5" stroke-miterlimit="10"
                                       stroke-linecap="round" stroke-linejoin="round" />
                                 </svg>
                              </span>
                           </a>
                        </div>
                        <div class="it-header-2-bar d-xl-none">
                           <button class="it-menu-bar"><i class="fa-solid fa-bars"></i></button>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- header-area-end -->

   </header>