<?php
include_once 'inc/navigation.php';
?>

   <main>

      <!-- slider-area-start -->
      <div class="it-slider-area fix">
         <div class="it-slider-wrap p-relative">
            <div class="it-slider-active">
               <div class="it-slider-bg it-slider-overlay d-flex align-items-center it-slider-height p-relative repeat no-repeat"
                    data-background="images/joysoundsacademy_banner_3.webp"
                    style="background-repeat: no-repeat !important;">
                  <div class="it-slider-shape-1 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-2.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="it-slider-shape-2 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-1.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="container">
                     <div class="row">
                        <div class="col-xl-7 col-lg-8">
                           <div class="it-hero-2-content z-index-5">
                                <h1 class="it-hero-2-title">Nurturing Brilliant Minds for a Stronger Future</h1>
                                <div class="it-hero-2-text">
                                    <p>Joy Sounds Academy & Junior School is a child-friendly learning environment in Makueni, dedicated to nurturing super brains through quality education for a quality life.</p>
                                </div>
                            </div>
                           <div class="it-hero-2-btn-box d-flex align-items-center">
                              <a class="it-btn-white sky-bg mr-30" href="documents/JoySoundAcademy_Fee&Admission_Letter.pdf" target="_blank">
                                 <span>
                                       Apply for Admission
                                       <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor"
                                             stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                             stroke-linejoin="round" />
                                          <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                             stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                       </svg>
                                 </span>
                              </a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="it-slider-bg it-slider-overlay d-flex align-items-center it-slider-height p-relative"
                  data-background="images/joysoundsacademy_banner_4.webp">
                  <div class="it-slider-shape-1 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-2.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="it-slider-shape-2 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-1.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="container">
                     <div class="row">
                        <div class="col-xl-7 col-lg-8">
                           <div class="it-hero-2-content z-index-5">
                              <h1 class="it-hero-2-title">Unlocking Potential, Inspiring Excellence</h1>
                              <div class="it-hero-2-text">
                                 <p>
                                    Providing quality education that meets the academic, spiritual, and social needs of every learner in a supportive environment.
                                 </p>
                              </div>
                           </div>

                           <div class="it-hero-2-btn-box d-flex align-items-center">
                              <a class="it-btn-white sky-bg mr-30" href="about.php">
                                 <span>
                                    Learn More About Our School
                                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                       xmlns="http://www.w3.org/2000/svg">
                                       <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor"
                                          stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                          stroke-linejoin="round" />
                                       <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                          stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                 </span>
                              </a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="it-slider-bg it-slider-overlay d-flex align-items-center it-slider-height p-relative"
                  data-background="images/joysoundsacademy_banner_5.webp">
                  <div class="it-slider-shape-1 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-2.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="it-slider-shape-2 d-none d-xl-block">
                     <img src="assets/img/slider/slider-shape-1.png" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="container">
                     <div class="row">
                        <div class="col-xl-7 col-lg-8">
                           <div class="it-hero-2-content z-index-5">
                              <h1 class="it-hero-2-title">Building the Minds of Tomorrow</h1>
                              <div class="it-hero-2-text">
                                 <p>
                                    A leading child-friendly primary school in Makueni, empowering learners to reach their highest academic potential.
                                 </p>
                              </div>
                           </div>

                           <div class="it-hero-2-btn-box d-flex align-items-center">
                              <a class="it-btn-white sky-bg mr-30" href="documents/JoySoundAcademy_Fee&Admission_Letter.pdf" target="_blank">
                                 <span>
                                    Enroll Your Child Today
                                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                       xmlns="http://www.w3.org/2000/svg">
                                       <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor"
                                          stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                          stroke-linejoin="round" />
                                       <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                          stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                 </span>
                              </a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="it-slider-nav-wrap z-index-5">
               <div class="it-slider-nav-active d-none d-lg-block">
                  <div class="it-slider-nav-thumb">
                     <img src="images/joysoundsacademy_banner_3.webp" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="it-slider-nav-thumb">
                     <img src="images/joysoundsacademy_banner_4.webp" alt="<?= $site_name ?>" loading="lazy">
                  </div>
                  <div class="it-slider-nav-thumb">
                     <img src="images/joysoundsacademy_banner_5.webp" alt="<?= $site_name ?>" loading="lazy">
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- slider-area-end -->

      <!-- feature-area-start -->
      <div class="it-feature-area grey-bg it-feature-2-style pt-120 pb-120">
         <div class="container">
            <div class="row">
               <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                  <div class="it-feature-item text-center">
                     <div class="it-feature-item-content z-index">
                        <div class="it-feature-icon">
                           <span><i class="flaticon-class"></i></span>
                        </div>
                        <div class="it-feature-text pt-30">
                           <h4 class="it-feature-title">Academic Excellence</h4>
                           <p>
                              A strong, structured curriculum designed to challenge learners, build confidence, and help every child reach their full academic potential.
                           </p>

                        </div>
                     </div>
                  </div>
               </div>

               <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                  <div class="it-feature-item text-center">
                     <div class="it-feature-item-content z-index">
                        <div class="it-feature-icon">
                           <span><i class="flaticon-bachelor"></i></span>
                        </div>
                        <div class="it-feature-text pt-30">
                           <h4 class="it-feature-title">Holistic Development</h4>
                           <p>
                              We support the academic, spiritual, social, and physical growth of every learner, shaping disciplined and well-rounded individuals.
                           </p>

                        </div>
                     </div>
                  </div>
               </div>

               <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                  <div class="it-feature-item text-center">
                     <div class="it-feature-item-content z-index">
                        <div class="it-feature-icon">
                           <span><i class="flaticon-study"></i></span>
                        </div>
                        <div class="it-feature-text pt-30">
                           <h4 class="it-feature-title">Child-Friendly Campus</h4>
                           <p>
                              Set in a calm and secure environment in Makueni, our campus offers modern facilities designed to support focused learning and child safety.
                           </p>

                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- feature-area-end -->

      <!-- about-area-start -->
      <div class="it-about-2-area p-relative pt-120 pb-120">
         <div class="it-about-2-shape-2 d-none d-xxl-block">
            <img src="assets/img/about/shape-2-2.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="it-about-2-big-text">
            <h6>About Us</h6>
         </div>
         <div class="container">
            <div class="row align-items-end">
               <div class="col-xl-6 col-lg-6 order-1 order-lg-0">
                  <div class="it-about-2-thumb-wrap d-flex justify-content-between">
                     <!--
                     <div class="it-about-2-thumb p-relative mt-95">
                        <img src="assets/img/about/thumb-2-1.jpg" alt="">
                        <div class="it-about-2-shape-1 d-none d-xxl-block">
                           <img src="assets/img/about/shape-2-1.png" alt="">
                        </div>
                     </div>-->
                     <div class="it-about-2-thumb">
                        <img src="images/student_joy_sounds_academy.webp" alt="<?= $site_name ?>" loading="lazy">
                     </div>
                  </div>
               </div>
               <div class="col-xl-6 col-lg-6 order-0 order-lg-1">
                  <div class="it-about-2-right">
                     <div class="it-about-2-title-box pb-25">
                        <span class="it-section-subtitle-2">About Joy Sounds Academy</span>
                        <h4 class="it-section-title">Where Curiosity Meets Excellence <br>
                              in Early Learning
                        </h4>
                     </div>
                     <div class="it-about-2-text pb-5">
                        <p>Joy Sounds Academy & Junior School, located in Makueni, provides a child-centered learning environment where every learner is guided to grow academically, socially, and emotionally. We focus on building confidence, curiosity, and a love for learning in a safe and supportive setting.</p>
                     </div>
                     <div class="it-about-2-text-2 mb-30">
                        <span>Our mission is to provide balanced, high-quality education that supports each child’s academic, social, physical, and spiritual development, helping them achieve their personal best.</span>
                     </div>
                     <div class="it-about-2-bottom d-flex justify-content-between align-items-end">
                        <div class="it-about-2-icon-wrap">
                              <div class="it-about-2-icon mb-25 d-flex align-items-center">
                                 <div style="position: relative; margin-right: 10px;">
                                    <i class="fas fa-book" style="color: #6E1B28; font-size: 24px;"></i>
                                 </div>
                                 <span>Holistic Development</span>
                              </div>
                              <div class="it-about-2-icon mb-35 d-flex align-items-center">
                                 <i class="fas fa-graduation-cap" style="color: #6E1B28; font-size: 24px; margin-right: 10px;"></i>
                                 <span>Child-Centered Campus</span>
                              </div>
                              <a class="it-btn-primary sky-bg" href="contact.php">
                                 <span>
                                    Schedule a Visit
                                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                             stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                          <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                             stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                 </span>
                              </a>
                        </div>
                        <div class="it-about-2-video p-relative">
                              <div class="it-about-2-thumb-sm">
                                 <img src="assets/img/about/thumb-sm.png" alt="Joy Sounds Students">
                              </div>
                              <div class="it-about-2-video-icon">
                                 <a class="popup-video play" href="https://www.youtube.com/watch?v=VIDEO_ID_HERE">
                                    <i class="fas fa-play"></i>
                                 </a>
                              </div>
                        </div>
                     </div>
                  </div>

               </div>
            </div>
         </div>
      </div>
      <!-- about-area-end -->

      <!-- cta-area-start -->
      <div class="it-cta-area it-cta-height black-bg p-relative">
         <div class="it-cta-bg d-none d-xl-block">
            <img src="images/graduating_students.webp" alt="<?= $site_name ?>" style="width: 500px;height:200px;object-fit:contain;" loading="lazy">
         </div>
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-9 col-lg-7 col-md-7">
                  <div class="it-cta-content">
                     <h4 class="it-cta-title">
                        Joy Sounds Academy provides the tools to <br> 
                        unlock your child's highest potential.
                     </h4>
                  </div>
               </div>
               <div class="col-xl-3 col-lg-5 col-md-5">
                  <div class="it-cta-button text-md-end">
                     <a class="it-btn-white sky-bg" href="about.php">
                        <span>
                           More About Us
                           <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                              xmlns="http://www.w3.org/2000/svg">
                              <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                 stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                              <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5" stroke-miterlimit="10"
                                 stroke-linecap="round" stroke-linejoin="round" />
                           </svg>
                        </span>
                     </a>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- cta-area-end -->

      <?php

      try {
         // Fetch portfolio items
         $sql = "SELECT id, title, slug, images, description, video_link 
                  FROM portfolio 
                  WHERE publish_status = 1 
                  ORDER BY RAND() 
                  LIMIT 9";
         
         $stmt = $pdo->prepare($sql);
         $stmt->execute();
         $portfolioItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
         
      } catch(PDOException $e) {
         error_log("Database error: " . $e->getMessage());
         $portfolioItems = [];
      }
      ?>

      <?php if (!empty($portfolioItems)): ?>
      <!-- Student Showcase Carousel - FIXED VERSION -->
      <div class="student-showcase-section" style="background-color: #ffffff; padding: 60px 0;">
         <div class="container">
            <!-- Section Header -->
            <div class="showcase-header" style="margin-bottom: 60px;">
                  <div class="row align-items-end">
                     <div class="col-xl-8 col-lg-8 col-md-8">
                        <div class="showcase-title-box">
                              <span class="showcase-subtitle" style="color: #7A1E2B; font-size: 16px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase; display: block; margin-bottom: 15px;">
                                 Student Showcase
                              </span>
                              <h2 class="showcase-title" style="color: #000000; font-size: 42px; font-weight: 700; line-height: 1.2; margin: 0;">
                                 Celebrating Excellence in<br>
                                 Drama, Arts & Graduations
                              </h2>
                        </div>
                     </div>
                     <div class="col-xl-4 col-lg-4 col-md-4 text-end">
                        <a href="portfolio.php" class="showcase-view-all-btn" style="display: inline-flex; align-items: center; color: #7A1E2B; text-decoration: none; font-weight: 600; font-size: 16px; padding: 10px 25px; border: 2px solid #7A1E2B; border-radius: 25px; transition: all 0.3s ease;">
                              View All Projects
                              <svg width="18" height="14" viewBox="0 0 17 14" fill="none" style="margin-left: 8px; transition: transform 0.3s ease;">
                                 <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                 <path d="M1 7.24023H16" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                              </svg>
                        </a>
                     </div>
                  </div>
            </div>

            <!-- Carousel Container -->
            <div class="showcase-carousel-wrapper" style="position: relative; overflow: hidden; padding: 0 60px;">
                  <!-- Navigation Arrows -->
                  <button class="showcase-carousel-prev" type="button" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); z-index: 10; width: 50px; height: 50px; background: white; color: #7A1E2B; border: 2px solid #7A1E2B; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.3s ease; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                     <i class="fas fa-chevron-left"></i>
                  </button>
                  
                  <button class="showcase-carousel-next" type="button" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); z-index: 10; width: 50px; height: 50px; background: white; color: #7A1E2B; border: 2px solid #7A1E2B; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.3s ease; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                     <i class="fas fa-chevron-right"></i>
                  </button>
                  
                  <!-- Carousel Track - USING FLEX WITH PROPER SIZING -->
                  <div class="showcase-carousel-track" style="display: flex; transition: transform 0.5s ease; padding: 10px 0;">
                     <?php foreach($portfolioItems as $item): ?>
                        <?php
                        // Extract data safely
                        $images = !empty($item['images']) ? explode(',', $item['images']) : [];
                        
                        // Get first image
                        $firstImage = '';
                        if (!empty($images[0])) {
                              $firstImage = trim($images[0]);
                              // Clean up path
                              $firstImage = preg_replace('/(assets\/img\/|portfolio_images\/)/', '', $firstImage);
                        }
                        
                        $imagePath = !empty($firstImage) ? "portfolio_images/{$firstImage}" : "assets/img/placeholder.jpg";
                        $slug = htmlspecialchars($item['slug'] ?? '');
                        $title = htmlspecialchars($item['title'] ?? 'Untitled');
                        
                        // Clean description
                        $description = '';
                        if (!empty($item['description'])) {
                              $cleanDesc = strip_tags($item['description']);
                              $description = strlen($cleanDesc) > 100 ? substr($cleanDesc, 0, 100) . '...' : $cleanDesc;
                        } else {
                              $description = 'No description available.';
                        }
                        
                        $videoLink = htmlspecialchars($item['video_link'] ?? '');
                        ?>
                        
                        <!-- Showcase Item -->
                        <div class="showcase-slide" style="flex: 0 0 100%; padding: 0 10px; box-sizing: border-box;">
                              <div class="showcase-card" style="border: 1px solid #f0f0f0; border-radius: 12px; overflow: hidden; height: 100%; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
                                 <!-- Media Container -->
                                 <div class="showcase-media" style="position: relative; overflow: hidden; height: 280px;">
                                    <?php if(!empty($videoLink)): ?>
                                          <!-- Video Thumbnail -->
                                          <div class="showcase-video-thumb" data-video="<?php echo $videoLink; ?>" style="position: relative; height: 100%; cursor: pointer;">
                                             <img src="<?php echo $imagePath; ?>" 
                                                   alt="<?php echo $title; ?>" 
                                                   style="width: 100%; height: 100%; object-fit: cover; background: #f5f5f5;"
                                                   onerror="this.src='assets/img/placeholder.jpg'">
                                             <div class="showcase-video-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(122, 30, 43, 0.7); display: flex; align-items: center; justify-content: center;">
                                                <div class="showcase-play-btn" style="width: 60px; height: 60px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                                      <svg width="24" height="24" viewBox="0 0 24 24" fill="#7A1E2B">
                                                         <path d="M8 5v14l11-7z"/>
                                                      </svg>
                                                </div>
                                             </div>
                                          </div>
                                    <?php else: ?>
                                          <!-- Image Gallery -->
                                          <div class="showcase-image-container" style="position: relative; height: 100%;">
                                             <img src="<?php echo $imagePath; ?>" 
                                                   alt="<?php echo $title; ?>" 
                                                   style="width: 100%; height: 100%; object-fit: cover; background: #f5f5f5;"
                                                   onerror="this.src='assets/img/placeholder.jpg'">
                                             <?php if(count($images) > 1): ?>
                                                <div class="showcase-image-count" style="position: absolute; top: 15px; right: 15px; background: white; color: #7A1E2B; width: 36px; height: 36px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 14px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                                                      +<?php echo count($images) - 1; ?>
                                                </div>
                                             <?php endif; ?>
                                          </div>
                                    <?php endif; ?>
                                 </div>
                                 
                                 <!-- Content -->
                                 <div class="showcase-content" style="padding: 25px; background: white;">
                                    <h3 class="showcase-item-title" style="color: #000000; font-size: 20px; font-weight: 600; margin: 0 0 15px 0; line-height: 1.3;">
                                          <?php echo $title; ?>
                                    </h3>
                                    <p class="showcase-description" style="color: #666666; font-size: 15px; line-height: 1.6; margin: 0 0 20px 0; min-height: 48px;">
                                          <?php echo $description; ?>
                                    </p>
                                    
                                    <!-- View Button -->
                                    <a href="blog-details.php?slug=<?php echo $slug; ?>" class="showcase-view-btn" style="display: inline-flex; align-items: center; color: #7A1E2B; text-decoration: none; font-weight: 600; font-size: 14px; padding: 8px 20px; border: 2px solid #7A1E2B; border-radius: 25px; transition: all 0.3s ease;">
                                          View Details
                                          <svg width="16" height="12" viewBox="0 0 17 14" fill="none" style="margin-left: 8px; transition: transform 0.3s ease;">
                                             <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                             <path d="M1 7.24023H16" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                          </svg>
                                    </a>
                                 </div>
                              </div>
                        </div>
                     <?php endforeach; ?>
                  </div>
            </div>

            <!-- Carousel Dots -->
            <?php if (count($portfolioItems) > 1): ?>
            <div class="showcase-carousel-dots" style="display: flex; justify-content: center; gap: 8px; margin-top: 40px;">
                  <?php 
                  $itemCount = count($portfolioItems);
                  $dotCount = $itemCount; // One dot per item
                  
                  for($i = 0; $i < $dotCount; $i++) {
                     echo '<button class="showcase-dot" data-showcase-index="' . $i . '" style="width: 12px; height: 12px; border-radius: 50%; border: 2px solid #7A1E2B; background: ' . ($i === 0 ? '#7A1E2B' : 'transparent') . '; cursor: pointer; transition: all 0.3s ease;"></button>';
                  }
                  ?>
            </div>
            <?php endif; ?>
         </div>
      </div>

      <!-- SIMPLIFIED CSS WITH PROPER SIZING -->
      <style>
      /* Student Showcase Specific Styles */
      .showcase-carousel-wrapper {
         overflow: hidden !important;
      }

      .showcase-carousel-track {
         display: flex;
         transition: transform 0.5s ease;
      }

      .showcase-slide {
         flex: 0 0 100%; /* Default for mobile: 1 item takes full width */
         padding: 0 10px;
         box-sizing: border-box;
      }

      .showcase-card {
         transition: all 0.3s ease;
         width: 100%;
      }

      .showcase-card:hover {
         transform: translateY(-8px);
         box-shadow: 0 15px 35px rgba(122, 30, 43, 0.15) !important;
      }

      .showcase-media img {
         transition: transform 0.5s ease;
         width: 100%;
      }

      .showcase-card:hover .showcase-media img {
         transform: scale(1.08);
      }

      /* Button Hover Effects */
      .showcase-view-btn:hover {
         background: #7A1E2B;
         color: white;
      }

      .showcase-view-btn:hover svg path {
         stroke: white;
      }

      .showcase-view-btn:hover svg {
         transform: translateX(5px);
      }

      .showcase-view-all-btn:hover {
         background: #7A1E2B;
         color: white;
      }

      .showcase-view-all-btn:hover svg path {
         stroke: white;
      }

      .showcase-view-all-btn:hover svg {
         transform: translateX(5px);
      }

      /* Arrow Hover Effects */
      .showcase-carousel-prev:hover,
      .showcase-carousel-next:hover {
         background: #7A1E2B !important;
         color: white !important;
         transform: translateY(-50%) scale(1.1);
      }

      /* Active Dot */
      .showcase-dot.active {
         background: #7A1E2B !important;
         transform: scale(1.2);
      }

      /* RESPONSIVE - PROPER SLIDE SIZING */
      @media (min-width: 768px) {
         .showcase-slide {
            flex: 0 0 calc(50% - 20px) !important; /* Tablet: 2 items */
            margin: 0 10px;
         }
      }

      @media (min-width: 992px) {
         .showcase-slide {
            flex: 0 0 calc(33.333% - 20px) !important; /* Desktop: 3 items */
            margin: 0 10px;
         }
      }

      @media (max-width: 767px) {
         .showcase-carousel-wrapper {
            padding: 0 20px !important;
         }
         
         .showcase-title {
            font-size: 32px !important;
         }
         
         .showcase-media {
            height: 220px !important;
         }
         
         .showcase-carousel-prev,
         .showcase-carousel-next {
            width: 40px !important;
            height: 40px !important;
         }
      }

      /* For very small devices */
      @media (max-width: 480px) {
         .showcase-carousel-wrapper {
            padding: 0 10px !important;
         }
         
         .showcase-slide {
            padding: 0 5px !important;
         }
         
         .showcase-carousel-prev,
         .showcase-carousel-next {
            width: 35px !important;
            height: 35px !important;
            left: 5px !important;
            right: 5px !important;
         }
      }
      </style>

      <!-- FIXED JAVASCRIPT - Accurate sliding calculation -->
      <script>
      // Self-contained Student Showcase Carousel - FIXED CALCULATION
      (function() {
         'use strict';
         
         document.addEventListener('DOMContentLoaded', function() {
            // Get elements
            const track = document.querySelector('.showcase-carousel-track');
            const slides = document.querySelectorAll('.showcase-slide');
            const prevBtn = document.querySelector('.showcase-carousel-prev');
            const nextBtn = document.querySelector('.showcase-carousel-next');
            const dots = document.querySelectorAll('.showcase-dot');
            
            if (!track || slides.length === 0) {
                  console.log('Student showcase carousel: No items found');
                  return;
            }
            
            console.log('Student showcase carousel: Initialized with', slides.length, 'slides');
            
            // Variables
            let currentSlide = 0;
            let autoSlideInterval;
            let slideWidth = 0;
            
            // Get visible slides count based on screen width
            function getVisibleSlides() {
                  const width = window.innerWidth;
                  if (width < 768) return 1;   // Mobile: 1 slide
                  if (width < 992) return 2;   // Tablet: 2 slides
                  return 3;                    // Desktop: 3 slides
            }
            
            // Calculate slide width
            function calculateSlideWidth() {
                  if (slides.length === 0) return 0;
                  
                  // Get the first slide's width including margin
                  const slide = slides[0];
                  const slideStyle = window.getComputedStyle(slide);
                  const width = slide.offsetWidth;
                  const marginLeft = parseInt(slideStyle.marginLeft) || 0;
                  const marginRight = parseInt(slideStyle.marginRight) || 0;
                  const paddingLeft = parseInt(slideStyle.paddingLeft) || 0;
                  const paddingRight = parseInt(slideStyle.paddingRight) || 0;
                  
                  return width + marginLeft + marginRight + paddingLeft + paddingRight;
            }
            
            // Get maximum slide index we can go to
            function getMaxSlide() {
                  const visibleSlides = getVisibleSlides();
                  return Math.max(0, slides.length - visibleSlides);
            }
            
            // Go to specific slide
            function goToSlide(slideIndex) {
                  const maxSlide = getMaxSlide();
                  slideIndex = Math.max(0, Math.min(slideIndex, maxSlide));
                  
                  // Recalculate slide width (in case of resize)
                  slideWidth = calculateSlideWidth();
                  
                  // Calculate position - each slide moves by its full width
                  const position = slideIndex * slideWidth;
                  
                  // Apply transform
                  track.style.transform = `translateX(-${position}px)`;
                  
                  // Update current slide
                  currentSlide = slideIndex;
                  
                  // Update dots
                  updateDots();
                  
                  console.log('Moved to slide', slideIndex, 'position', position, 'slideWidth', slideWidth);
            }
            
            // Next slide
            function nextSlide() {
                  const maxSlide = getMaxSlide();
                  if (currentSlide >= maxSlide) {
                     // Loop back to start
                     goToSlide(0);
                  } else {
                     goToSlide(currentSlide + 1);
                  }
            }
            
            // Previous slide
            function prevSlide() {
                  const maxSlide = getMaxSlide();
                  if (currentSlide <= 0) {
                     // Loop to end
                     goToSlide(maxSlide);
                  } else {
                     goToSlide(currentSlide - 1);
                  }
            }
            
            // Update dots
            function updateDots() {
                  dots.forEach((dot, index) => {
                     const isActive = index === currentSlide;
                     dot.classList.toggle('active', isActive);
                     dot.style.background = isActive ? '#7A1E2B' : 'transparent';
                     dot.style.transform = isActive ? 'scale(1.2)' : 'scale(1)';
                  });
            }
            
            // Start auto slide
            function startAutoSlide() {
                  stopAutoSlide();
                  
                  // Only auto slide if we have more than 1 slide visible
                  if (slides.length <= 1 || getVisibleSlides() >= slides.length) return;
                  
                  autoSlideInterval = setInterval(() => {
                     nextSlide();
                  }, 4000); // 4 seconds
            }
            
            // Stop auto slide
            function stopAutoSlide() {
                  if (autoSlideInterval) {
                     clearInterval(autoSlideInterval);
                     autoSlideInterval = null;
                  }
            }
            
            // Reset auto slide
            function resetAutoSlide() {
                  stopAutoSlide();
                  startAutoSlide();
            }
            
            // Event Listeners
            if (prevBtn) {
                  prevBtn.addEventListener('click', (e) => {
                     e.preventDefault();
                     prevSlide();
                     resetAutoSlide();
                  });
            }
            
            if (nextBtn) {
                  nextBtn.addEventListener('click', (e) => {
                     e.preventDefault();
                     nextSlide();
                     resetAutoSlide();
                  });
            }
            
            // Dot navigation
            dots.forEach(dot => {
                  dot.addEventListener('click', function(e) {
                     e.preventDefault();
                     const index = parseInt(this.getAttribute('data-showcase-index') || '0');
                     goToSlide(index);
                     resetAutoSlide();
                  });
            });
            
            // Video click
            document.querySelectorAll('.showcase-video-thumb').forEach(thumb => {
                  thumb.addEventListener('click', function(e) {
                     const videoUrl = this.getAttribute('data-video');
                     if (videoUrl) {
                        e.preventDefault();
                        window.open(videoUrl, '_blank');
                     }
                  });
            });
            
            // Pause on hover
            if (slides.length > 1) {
                  track.addEventListener('mouseenter', stopAutoSlide);
                  track.addEventListener('mouseleave', startAutoSlide);
            }
            
            // Handle resize - recalculate everything
            let resizeTimeout;
            window.addEventListener('resize', () => {
                  clearTimeout(resizeTimeout);
                  resizeTimeout = setTimeout(() => {
                     // Recalculate slide width
                     slideWidth = calculateSlideWidth();
                     
                     // Re-go to current slide with new calculations
                     goToSlide(currentSlide);
                     
                     console.log('Resized: slideWidth', slideWidth, 'visibleSlides', getVisibleSlides());
                  }, 250);
            });
            
            // Initialize
            slideWidth = calculateSlideWidth();
            goToSlide(0);
            updateDots();
            startAutoSlide();
            
            // Debug info
            console.log('Initial slideWidth:', slideWidth);
            console.log('Visible slides:', getVisibleSlides());
            console.log('Max slide:', getMaxSlide());
            
            // Add touch/swipe for mobile
            let startX = 0;
            let currentX = 0;
            let isDragging = false;
            
            if (slides.length > 1) {
                  track.addEventListener('touchstart', (e) => {
                     startX = e.touches[0].clientX;
                     currentX = startX;
                     isDragging = true;
                     track.style.transition = 'none';
                  }, { passive: true });
                  
                  track.addEventListener('touchmove', (e) => {
                     if (!isDragging) return;
                     currentX = e.touches[0].clientX;
                     const diff = startX - currentX;
                     const currentPosition = currentSlide * slideWidth;
                     track.style.transform = `translateX(-${currentPosition + diff}px)`;
                  }, { passive: true });
                  
                  track.addEventListener('touchend', () => {
                     if (!isDragging) return;
                     isDragging = false;
                     
                     const diff = startX - currentX;
                     const threshold = slideWidth / 4; // 25% threshold for swipe
                     
                     if (Math.abs(diff) > threshold) {
                        if (diff > 0) {
                              nextSlide();
                        } else {
                              prevSlide();
                        }
                     } else {
                        // Return to current position
                        goToSlide(currentSlide);
                     }
                     
                     track.style.transition = 'transform 0.5s ease';
                     resetAutoSlide();
                  });
            }
         });
      })();
      </script>

      <?php else: ?>
      <!-- No items message -->
      <div class="container py-5">
         <div class="text-center">
            <p style="color: #666; font-size: 18px;">No portfolio items found.</p>
         </div>
      </div>
      <?php endif; ?>
      

      <!-- testimonial-area-start -->
      <div class="it-testimonial-5-area it-testimonial-style-2 p-relative pt-120 pb-120">
         <div class="it-testimonial-5-shape-5 d-none d-xl-block">
            <i class="fas fa-asterisk" style="color: #6E1B28; font-size: 208px;"></i>
         </div>
         <div class="it-testimonial-5-shape-6 d-none d-xl-block">
            <i class="fas fa-graduation-cap" style="color: #6E1B28; font-size: 108px;"></i>
         </div>
         <div class="it-testimonial-5-shape-7 d-none d-xl-block">
            <img src="assets/img/testimonial/shape-5-8.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="container">
            <div class="row">
               <div class="col-xl-12">
                  <div class="it-testimonial-5-title-box text-center mb-60">
                        <span class="it-section-subtitle-2">Testimonials</span>
                        <h4 class="it-section-title-5">Creating A Community Of <br> Lifelong Learners</h4>
                  </div>
               </div>
               <div class="col-xl-12">
                  <div class="it-testimonial-5-wrapper p-relative">
                        <div class="swiper-container it-testimonial-5-active">
                           <div class="swiper-wrapper">

                              <!-- Testimonial 1 -->
                              <div class="swiper-slide">
                                    <div class="it-testimonial-5-item p-relative z-index">
                                       <div class="it-testimonial-3-author-box d-flex align-items-center mb-20">
                                          <div class="it-testimonial-3-avata text-white">
                                             <i class="fa fa-user fa-2x"></i>
                                          </div>
                                          <div class="it-testimonial-3-author-info">
                                                <h5>Amina Mwende</h5>
                                                <span class="text-white">Parent</span>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-content z-index-5">
                                          <div class="it-testimonial-5-star pb-10">
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                          </div>
                                          <div class="it-testimonial-5-text">
                                                <p>"Since joining Joy Sounds Academy, my child has blossomed in confidence and curiosity. The teachers genuinely care, and the learning environment is both nurturing and inspiring."</p>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-quote d-none d-xl-block">
                                          <img src="assets/img/testimonial/quote-1-2.png" alt="">
                                       </div>
                                    </div>
                              </div>

                              <!-- Testimonial 2 -->
                              <div class="swiper-slide">
                                    <div class="it-testimonial-5-item p-relative z-index">
                                       <div class="it-testimonial-3-author-box d-flex align-items-center mb-20">
                                          <div class="it-testimonial-3-avata text-white">
                                             <i class="fa fa-user fa-2x"></i>
                                          </div>
                                          <div class="it-testimonial-3-author-info">
                                                <h5>James Otieno</h5>
                                                <span class="text-white">Student</span>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-content z-index-5">
                                          <div class="it-testimonial-5-star pb-10">
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                          </div>
                                          <div class="it-testimonial-5-text">
                                                <p>"I love coming to school every day! The teachers explain things so well, and I’ve made lots of friends. Learning here is fun and exciting!"</p>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-quote d-none d-xl-block">
                                          <img src="assets/img/testimonial/quote-1-2.png" alt="">
                                       </div>
                                    </div>
                              </div>

                              <!-- Testimonial 3 -->
                              <div class="swiper-slide">
                                    <div class="it-testimonial-5-item p-relative z-index">
                                       <div class="it-testimonial-3-author-box d-flex align-items-center mb-20">
                                          <div class="it-testimonial-3-avata text-white">
                                             <i class="fa fa-user fa-2x"></i>
                                          </div>
                                          <div class="it-testimonial-3-author-info">
                                                <h5>Fatuma Njeri</h5>
                                                <span class="text-white">Parent</span>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-content z-index-5">
                                          <div class="it-testimonial-5-star pb-10">
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                                <i class="fa-sharp fa-solid fa-star"></i>
                                          </div>
                                          <div class="it-testimonial-5-text">
                                                <p>"Joy Sounds Academy has a wonderful learning atmosphere. The focus on both academics and personal growth gives my child a strong foundation for the future."</p>
                                          </div>
                                       </div>
                                       <div class="it-testimonial-5-quote d-none d-xl-block">
                                          <img src="assets/img/testimonial/quote-1-2.png" alt="">
                                       </div>
                                    </div>
                              </div>

                           </div>
                        </div>
                  </div>
               </div>
            </div>

         </div>
      </div>
      <!-- testimonial-area-end -->

      <!-- video-area-start -->
      <div class="it-video-area it-video-style-2 it-video-bg p-relative fix pt-100 pb-95"
         data-background="images/students_in_class_joy_studio_academy.webp">
         <div class="it-video-shape-1 d-none d-lg-block">
            <img src="assets/img/video/shape-1-6.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="it-video-shape-2 d-none d-lg-block">
            <img src="assets/img/video/shape-1-2.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="it-video-shape-3 d-none d-lg-block">
            <img src="assets/img/video/shape-1-7.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="it-video-shape-4 d-none d-lg-block">
            <img src="assets/img/video/shape-1-4.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="it-video-shape-5 d-none d-lg-block">
            <img src="assets/img/video/shape-1-5.png" alt="<?= $site_name ?>" loading="lazy">
         </div>
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-7 col-lg-7 col-md-9 col-sm-9">
                  <div class="it-video-content text-center">
                     <span>Enroll Your Child Today</span>
                     <h3 class="it-video-title">
                        Start Your Child’s Journey to Excellence <br>
                        <a href="tel:<?= $site_hotline; ?>"><?= $site_hotline; ?></a>
                     </h3>
                     <div class="it-video-button mt-4">
                        <a class="it-btn blue-bg" href="contact.php">
                              <span>
                                 Schedule a Visit
                                 <svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                          stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5"
                                          stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                 </svg>
                              </span>
                        </a>
                     </div>
                  </div>
               </div>
               <div class="col-xl-5 col-lg-5 col-md-3 col-sm-3">
                  <div
                     class="it-video-play-wrap d-flex justify-content-start justify-content-md-end align-items-center">
                     <div class="it-video-play text-center">
                        <a class="popup-video play" href="https://www.youtube.com/watch?v=PO_fBTkoznc"><i
                              class="fas fa-play"></i></a>
                        <a class="text" href="#">watch now</a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- video-area-end -->

      <!-- event-area-start -->
      <div class="it-event-2-area p-relative pt-90 pb-90">
         <div class="container">
            <div class="it-event-2-title-wrap mb-60">
               <div class="row align-items-end">
                  <div class="col-12">
                     <div class="it-event-2-title-box text-center">
                        <span class="it-section-subtitle-2">School Life</span>
                        <h2 class="it-section-title-3">Stories, Updates & School Activities</h2>
                     </div>
                  </div>
               </div>
            </div>
            <?php
            try {
               // Fetch blog items with published status
               $sql = "SELECT * FROM blog WHERE publish_status = '1' ORDER BY date DESC LIMIT 3";
               $stmt = $pdo->prepare($sql);
               $stmt->execute();
               $blogItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
            } catch(PDOException $e) {
               die("Database error: " . $e->getMessage());
            }
            ?>

            <div class="row">
               <?php
               if (!empty($blogItems)) {
                  foreach($blogItems as $blog) {
                        // Get first image from comma-separated list
                        $images = !empty($blog['blog_image']) ? explode(',', $blog['blog_image']) : [];
                        $firstImage = !empty($images[0]) ? 'blog_images/' . trim($images[0]) : 'assets/img/event/event-1-1.jpg';
                        
                        // Get blog content from text file
                        $blogContent = '';
                        if (!empty($blog['blog']) && file_exists('blog/' . $blog['blog'])) {
                           $content = file_get_contents('blog/' . $blog['blog']);
                           $blogContent = substr(strip_tags($content), 0, 100) . '...';
                        } else {
                           $blogContent = 'No content available...';
                        }
                        
                        // Format date
                        $blogDate = !empty($blog['date']) ? strtotime($blog['date']) : time();
                        $day = date('d', $blogDate);
                        $month = date('F', $blogDate);
                        ?>
                        
                        <div class="col-xl-4 col-lg-6 col-md-6 mb-30">
                           <div class="it-event-2-item-box">
                              <div class="it-event-2-item">
                                    <div class="it-event-2-thumb fix">
                                       <a href="event-details.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>">
                                          <img src="<?php echo htmlspecialchars($firstImage); ?>" alt="<?php echo htmlspecialchars($blog['blog_title']); ?>">
                                       </a>
                                       <div class="it-event-2-date">
                                          <span>
                                                <i><?php echo $day; ?></i><br>
                                                <?php echo substr($month, 0, 3); ?>
                                          </span>
                                       </div>
                                    </div>
                                    <div class="it-event-2-content">
                                       <h4 class="it-event-2-title">
                                          <a href="event-details.php?slug=<?php echo htmlspecialchars($blog['slug']); ?>">
                                                <?php echo htmlspecialchars($blog['blog_title']); ?>
                                          </a>
                                       </h4>
                                       <div class="it-event-2-text">
                                          <p class="mb-0 pb-10"><?php echo htmlspecialchars($blogContent); ?></p>
                                       </div>
                                       <div class="it-event-2-meta">
                                          <span>
                                                <i class="fa-light fa-clock"></i>
                                                Time: <?php echo date('h:ia', $blogDate); ?>
                                          </span>
                                          <span>
                                                <a href="#">
                                                   <i class="fa-light fa-location-dot"></i>
                                                </a>
                                                Author: <?php echo htmlspecialchars($blog['author']); ?>
                                          </span>
                                       </div>
                                       
                                       <!-- Additional blog info -->
                                       <div class="it-event-2-meta mt-2">
                                          <span>
                                                <i class="fa-light fa-eye"></i>
                                                Views: <?php echo htmlspecialchars($blog['views']); ?>
                                          </span>
                                          <span>
                                                <i class="fa-light fa-heart"></i>
                                                Likes: <?php echo htmlspecialchars($blog['likes']); ?>
                                          </span>
                                       </div>
                                    </div>
                              </div>
                           </div>
                        </div>
                        
                        <?php
                  }
               } else {
                  // Show placeholder if no blog items
                  ?>
                  <div class="col-12 text-center">
                        <p>No blog posts available.</p>
                  </div>
                  <?php
               }
               ?>
            </div>
         </div>
      </div>
      <!-- event-area-end -->

      <!-- faq-area-start -->
      <div class="it-faq-area p-relative pt-120 pb-120">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-xl-6 col-lg-6">
                  <div class="it-faq-thumb text-center text-lg-start">
                     <img 
                        src="images/student_joy_sounds_academy_2.webp" 
                        alt="Student Joy Sounds Academy" 
                        loading="lazy" 
                        style="
                              max-width: 600px; 
                              width: 100%; 
                              height: auto;
                        "
                        class="img-fluid"
                     >
                  </div>
               </div>
               <div class="col-xl-6 col-lg-6">
                  <div class="it-faq-wrap">
                     <div class="it-faq-title-box mb-20">
                        <span class="it-section-subtitle-2">FAQs</span>
                        <h4 class="it-section-title-5">Answers Parents Often Ask</h4>
                     </div>
                     <div class="it-custom-accordion it-custom-accordion-style-2">
                        <div class="accordion" id="accordionExample">

                              <!-- FAQ 1 -->
                              <div class="accordion-items tp-faq-active">
                                 <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-buttons" type="button" data-bs-toggle="collapse"
                                          data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                          What curriculum does Joy Sounds Academy follow?
                                    </button>
                                 </h2>
                                 <div id="collapseOne" class="accordion-collapse collapse show"
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body d-flex align-items-center">
                                          <p class="mb-0">
                                             We follow a structured curriculum designed to support strong academic foundations while
                                             encouraging creativity, critical thinking, and holistic development in every learner.
                                          </p>
                                    </div>
                                 </div>
                              </div>

                              <!-- FAQ 2 -->
                              <div class="accordion-items">
                                 <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-buttons collapsed" type="button" data-bs-toggle="collapse"
                                          data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                          What age groups do you admit?
                                    </button>
                                 </h2>
                                 <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body d-flex align-items-center">
                                          <p class="mb-0">
                                             Joy Sounds Academy admits learners from early childhood through junior school, ensuring
                                             age-appropriate learning experiences in a safe and supportive environment.
                                          </p>
                                    </div>
                                 </div>
                              </div>

                              <!-- FAQ 3 -->
                              <div class="accordion-items">
                                 <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-buttons collapsed" type="button" data-bs-toggle="collapse"
                                          data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                          How does the school support each child’s growth?
                                    </button>
                                 </h2>
                                 <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body d-flex align-items-center">
                                          <p class="mb-0">
                                             We focus on the academic, social, emotional, and physical development of each child through
                                             personalized attention, caring teachers, and a balanced learning approach.
                                          </p>
                                    </div>
                                 </div>
                              </div>

                              <!-- FAQ 4 -->
                              <div class="accordion-items">
                                 <h2 class="accordion-header" id="headingFour">
                                    <button class="accordion-buttons collapsed" type="button" data-bs-toggle="collapse"
                                          data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                          How can parents get involved or stay informed?
                                    </button>
                                 </h2>
                                 <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body d-flex align-items-center">
                                          <p class="mb-0">
                                             We maintain open communication with parents through regular updates, meetings, and school
                                             activities, ensuring strong partnerships in every child’s learning journey.
                                          </p>
                                    </div>
                                 </div>
                              </div>

                        </div>
                     </div>
                  </div>

               </div>
            </div>
         </div>
      </div>
      <!-- faq-area-end -->

   </main>
<?php
require_once 'inc/footer.php';
?>
